using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Login : Form
  {
    private string username = "";
    private string password = "";
    private string sessionkey = "";

    public Login()
    {
      InitializeComponent();
      Error_Message_Label.Text = "";
    }

    /// <summary>
    /// User has clicked the log in button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Login_Button_Click(object sender, EventArgs e)
    {
      //get user typed info
      username = Username_Field.Text;
      password = Password_Field.Text;
      Error_Message_Label.Text = "";

      //create link to our webservice
      OutboundUtilityWS.OutboundUtilityWS UtilInvoke = new OutboundUtilityWS.OutboundUtilityWS();

      //invoke our webservice
      try
      {
        sessionkey = UtilInvoke.OutboundLogin(username, password);
      }
      catch(SoapException ex)
      {
        Error_Message_Label.Text = ex.Detail.InnerText;
        Error_Message_Label.Refresh();
        if(ex.Detail.InnerText.Contains("19021"))
        {
          //user is already logged in
          PromtLogout();
        }
      }
      if(sessionkey.Contains("__"))
      {
        //then this is a valid session key
        GlobalDef.getInstance().IsAccessGranted = true;
        GlobalDef.getInstance().MySessionKey = sessionkey;
        GlobalDef.getInstance().MyUserName = username;
        this.Hide();
        Main MainPage = new Main();
        MainPage.ShowDialog();
        Application.Exit();       
      }    
    }

    /// <summary>
    /// User is already logged in and we prompt the user to log out
    /// </summary>
    private void PromtLogout()
    {
      if(MessageBox.Show("Do you use wish to log out " + username + "?","", MessageBoxButtons.OKCancel) == DialogResult.OK)
      {
        OutboundUtilityWS.OutboundUtilityWS UtilInvoke = new OutboundUtilityWS.OutboundUtilityWS();

        //invoke our webservice
        try
        {
          UtilInvoke.OutboundLogoff(username);
        }
        catch(SoapException ex)
        {
          //error message here
        }
      }
    }

    /// <summary>
    /// User has cancelled the log in 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Cancel_Button_Click(object sender, EventArgs e)
    {
      GlobalDef.getInstance().MyQuit = true;
      Application.Exit();
    }
  }
}